<?php

add_filter('widget_text', 'do_shortcode');
add_filter('call_to_action_widget', 'do_shortcode');

if (!function_exists('edge_core_core_version_class')) {
    /**
     * Adds plugins version class to body
     * @param $classes
     * @return array
     */
    function edge_core_core_version_class($classes)
    {
        $classes[] = 'edgt-core-' . EDGE_CORE_VERSION;

        return $classes;
    }

    add_filter('body_class', 'edge_core_core_version_class');
}

if (!function_exists('edge_core_theme_installed')) {
    /**
     * Checks whether theme is installed or not
     * @return bool
     */
    function edge_core_theme_installed()
    {
        return defined('HUDSON_EDGE');
    }
}

if (!function_exists('edge_core_is_installed')) {
    /**
     * Function that checks if forward module installed
     *
     * @param $name string - module name
     *
     * @return bool
     */
    function edge_core_is_installed($name)
    {

        switch ($name) {
            case 'theme';
                return defined('HUDSON_EDGE');
                break;
            case 'woocommerce';
                return function_exists('is_woocommerce');
                break;
            case 'gutenberg-editor';
                return function_exists('register_block_type');
                break;
            default:
                return false;
        }
    }
}

if (!function_exists('edge_core_get_carousel_slider_array')) {
    /**
     * Function that returns associative array of carousels,
     * where key is term slug and value is term name
     * @return array
     */
    function edge_core_get_carousel_slider_array()
    {
        $carousels_array = array();
        $terms = get_terms('carousels_category');

        if (is_array($terms) && count($terms)) {
            $carousels_array[''] = '';
            foreach ($terms as $term) {
                $carousels_array[$term->slug] = $term->name;
            }
        }

        return $carousels_array;
    }
}

if (!function_exists('edge_core_get_carousel_slider_array_vc')) {
    /**
     * Function that returns array of carousels formatted for Visual Composer
     *
     * @return array array of carousels where key is term title and value is term slug
     *
     * @see edge_core_get_carousel_slider_array
     */
    function edge_core_get_carousel_slider_array_vc()
    {
        return array_flip(edge_core_get_carousel_slider_array());
    }
}

/* Function for adding custom meta boxes hooked to default action */
if (!function_exists('edge_core_include_meta_boxes')) {
    function edge_core_include_meta_boxes()
    {
        if (class_exists('WP_Block_Type') && edge_core_is_installed('theme')) {
            add_action('admin_head', 'hudson_edge_meta_box_add');
        } else if (edge_core_is_installed('theme')) {
            add_action('add_meta_boxes', 'hudson_edge_meta_box_add');
        }
    }

    add_action('after_setup_theme', 'edge_core_include_meta_boxes');
}


if (!function_exists('edge_core_create_meta_box_handler')) {
    function edge_core_create_meta_box_handler($box, $key, $screen)
    {
        add_meta_box(
            'edgtf-meta-box-' . $key,
            $box->title,
            'hudson_edge_render_meta_box',
            $box->scope,
            'advanced',
            'high',
            array('box' => $box)
        );
    }
}

if (!function_exists('edge_core_theme_menu')) {
    /**
     * Function that generates admin menu for options page.
     * It generates one admin page per options page.
     */
    function edge_core_theme_menu()
    {
        if (edge_core_theme_installed('theme')) {
            global $hudson_edge_framework;
            hudson_edge_init_theme_options();

            $page_hook_suffix = add_menu_page(
                'Edge Options',
                // The value used to populate the browser's title bar when the menu page is active
                'Edge Options',
                // The text of the menu in the administrator's sidebar
                'administrator',
                // What roles are able to access the menu
                'edgt_theme_menu',
                // The ID used to bind submenu items to this menu
                array($hudson_edge_framework->getSkin(), 'renderOptions'),
                // The callback function used to render this menu
                $hudson_edge_framework->getSkin()->getMenuIcon('options'),
                // Icon For menu Item
                $hudson_edge_framework->getSkin()->getMenuItemPosition('options')            // Position
            );

            foreach ($hudson_edge_framework->edgtOptions->adminPages as $key => $value) {
                $slug = "";

                if (!empty($value->slug)) {
                    $slug = "_tab" . $value->slug;
                }

                $subpage_hook_suffix = add_submenu_page(
                    'edgt_theme_menu',
                    'Edge Options - ' . $value->title,
                    // The value used to populate the browser's title bar when the menu page is active
                    $value->title,
                    // The text of the menu in the administrator's sidebar
                    'administrator',
                    // What roles are able to access the menu
                    'edgt_theme_menu' . $slug,
                    // The ID used to bind submenu items to this menu
                    array($hudson_edge_framework->getSkin(), 'renderOptions')
                );

                add_action(
                    'admin_print_scripts-' . $subpage_hook_suffix,
                    'hudson_edge_enqueue_admin_scripts'
                );
                add_action(
                    'admin_print_styles-' . $subpage_hook_suffix,
                    'hudson_edge_enqueue_admin_styles'
                );
            };

            add_action(
                'admin_print_scripts-' . $page_hook_suffix,
                'hudson_edge_enqueue_admin_scripts'
            );
            add_action(
                'admin_print_styles-' . $page_hook_suffix,
                'hudson_edge_enqueue_admin_styles'
            );
        }
    }

    add_action('admin_menu', 'edge_core_theme_menu');
}

if (!function_exists('edge_core_register_theme_settings')) {
    /**
     * Function that registers setting that will be used to store theme options
     */
    function edge_core_register_theme_settings()
    {
        register_setting('edge_core_theme_menu', 'edgt_options');
    }

    add_action('admin_init', 'edge_core_register_theme_settings');
}